'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Balken_fuellen()
    Dim RotNachWeiss As Double
    Dim RotNachSchwarz As Double
    Dim GruenNachWeiss As Double
    Dim GruenNachSchwarz As Double
    Dim BlauNachWeiss As Double
    Dim BlauNachSchwarz As Double

    RotNachWeiss = 0
    RotNachSchwarz = 0
    GruenNachWeiss = 0
    GruenNachSchwarz = 0
    BlauNachWeiss = 0
    BlauNachSchwarz = 0
    
    'Zwischenfarben berechnen
    
    'Faktoren ermitteln
    Select Case RGB_Rot
        Case 0
            RotNachWeiss = 255 / 5
            RotNachSchwarz = 0
        Case 255
            RotNachWeiss = 255
            RotNachSchwarz = 255 / 5
        Case Else
            RotNachWeiss = (255 - RGB_Rot) / 5
            RotNachSchwarz = RGB_Rot / 5
    End Select
    
    Select Case RGB_Gruen
        Case 0
            GruenNachWeiss = 255 / 5
            GruenNachSchwarz = 0
        Case 255
            GruenNachWeiss = 255
            GruenNachSchwarz = 255 / 5
        Case Else
            GruenNachWeiss = (255 - RGB_Gruen) / 5
            GruenNachSchwarz = RGB_Gruen / 5
    End Select
    
    Select Case RGB_Blau
        Case 0
            BlauNachWeiss = 255 / 5
            BlauNachSchwarz = 0
        Case 255
            BlauNachWeiss = 255
            BlauNachSchwarz = 255 / 5
        Case Else
            BlauNachWeiss = (255 - RGB_Blau) / 5
            BlauNachSchwarz = RGB_Blau / 5
    End Select
    
    'Farbverlauf nach Wei
    If RotNachWeiss = 255 Then
        RGB_Rot1 = 255
        RGB_Rot2 = 255
        RGB_Rot3 = 255
        RGB_Rot4 = 255
    Else
        RGB_Rot1 = RGB_Rot + Fix(RotNachWeiss * 4)
        RGB_Rot2 = RGB_Rot + Fix(RotNachWeiss * 3)
        RGB_Rot3 = RGB_Rot + Fix(RotNachWeiss * 2)
        RGB_Rot4 = RGB_Rot + Fix(RotNachWeiss * 1)
    End If
    
    If GruenNachWeiss = 255 Then
        RGB_Gruen1 = 255
        RGB_Gruen2 = 255
        RGB_Gruen3 = 255
        RGB_Gruen4 = 255
    Else
        RGB_Gruen1 = RGB_Gruen + Fix(GruenNachWeiss * 4)
        RGB_Gruen2 = RGB_Gruen + Fix(GruenNachWeiss * 3)
        RGB_Gruen3 = RGB_Gruen + Fix(GruenNachWeiss * 2)
        RGB_Gruen4 = RGB_Gruen + Fix(GruenNachWeiss * 1)
    End If
    
    If BlauNachWeiss = 255 Then
        RGB_Blau1 = 255
        RGB_Blau2 = 255
        RGB_Blau3 = 255
        RGB_Blau4 = 255
    Else
        RGB_Blau1 = RGB_Blau + Fix(BlauNachWeiss * 4)
        RGB_Blau2 = RGB_Blau + Fix(BlauNachWeiss * 3)
        RGB_Blau3 = RGB_Blau + Fix(BlauNachWeiss * 2)
        RGB_Blau4 = RGB_Blau + Fix(BlauNachWeiss * 1)
    End If
    
    'Farbverlauf nach Schwarz
    If RotNachSchwarz = 0 Then
        RGB_Rot5 = 0
        RGB_Rot6 = 0
        RGB_Rot7 = 0
        RGB_Rot8 = 0
    Else
        RGB_Rot5 = Fix(RotNachSchwarz * 4)
        RGB_Rot6 = Fix(RotNachSchwarz * 3)
        RGB_Rot7 = Fix(RotNachSchwarz * 2)
        RGB_Rot8 = Fix(RotNachSchwarz * 1)
    End If
    
    If GruenNachSchwarz = 0 Then
        RGB_Gruen5 = 0
        RGB_Gruen6 = 0
        RGB_Gruen7 = 0
        RGB_Gruen8 = 0
    Else
        RGB_Gruen5 = Fix(GruenNachSchwarz * 4)
        RGB_Gruen6 = Fix(GruenNachSchwarz * 3)
        RGB_Gruen7 = Fix(GruenNachSchwarz * 2)
        RGB_Gruen8 = Fix(GruenNachSchwarz * 1)
    End If
    
    If BlauNachSchwarz = 0 Then
        RGB_Blau5 = 0
        RGB_Blau6 = 0
        RGB_Blau7 = 0
        RGB_Blau8 = 0
    Else
        RGB_Blau5 = Fix(BlauNachSchwarz * 4)
        RGB_Blau6 = Fix(BlauNachSchwarz * 3)
        RGB_Blau7 = Fix(BlauNachSchwarz * 2)
        RGB_Blau8 = Fix(BlauNachSchwarz * 1)
    End If
    
    
    'Balken mit Zwischenfarben fllen
    Me.Balken_Links.BackColor = RGB(255, 255, 255)
    
    Me.Balken_Links1.BackColor = RGB(RGB_Rot1, RGB_Gruen1, RGB_Blau1)
    Me.Balken_Links2.BackColor = RGB(RGB_Rot2, RGB_Gruen2, RGB_Blau2)
    Me.Balken_Links3.BackColor = RGB(RGB_Rot3, RGB_Gruen3, RGB_Blau3)
    Me.Balken_Links4.BackColor = RGB(RGB_Rot4, RGB_Gruen4, RGB_Blau4)
    
    Me.Balken_Mitte.BackColor = RGB(RGB_Rot, RGB_Gruen, RGB_Blau)
    
    Me.Balken_Mitte1.BackColor = RGB(RGB_Rot5, RGB_Gruen5, RGB_Blau5)
    Me.Balken_Mitte2.BackColor = RGB(RGB_Rot6, RGB_Gruen6, RGB_Blau6)
    Me.Balken_Mitte3.BackColor = RGB(RGB_Rot7, RGB_Gruen7, RGB_Blau7)
    Me.Balken_Mitte4.BackColor = RGB(RGB_Rot8, RGB_Gruen8, RGB_Blau8)
    
    Me.Balken_Rechts.BackColor = RGB(0, 0, 0)
    
    'Vorschau Farbauswahl fllen
    Balken_Mitte_Click
    
End Sub

Private Sub Balken_Links_Click()
    Me.Farbe_Neu.BackColor = RGB(255, 255, 255)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = 255
    RGB_GruenNeu = 255
    RGB_BlauNeu = 255
End Sub

Private Sub Balken_Links1_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot1, RGB_Gruen1, RGB_Blau1)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot1
    RGB_GruenNeu = RGB_Gruen1
    RGB_BlauNeu = RGB_Blau1
End Sub

Private Sub Balken_Links2_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot2, RGB_Gruen2, RGB_Blau2)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot2
    RGB_GruenNeu = RGB_Gruen2
    RGB_BlauNeu = RGB_Blau2
End Sub

Private Sub Balken_Links3_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot3, RGB_Gruen3, RGB_Blau3)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot3
    RGB_GruenNeu = RGB_Gruen3
    RGB_BlauNeu = RGB_Blau3
End Sub

Private Sub Balken_Links4_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot4, RGB_Gruen4, RGB_Blau4)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot
    RGB_GruenNeu = RGB_Gruen
    RGB_BlauNeu = RGB_Blau
End Sub

Private Sub Balken_Mitte_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot, RGB_Gruen, RGB_Blau)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot
    RGB_GruenNeu = RGB_Gruen
    RGB_BlauNeu = RGB_Blau
End Sub

Private Sub Balken_Mitte1_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot5, RGB_Gruen5, RGB_Blau5)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot5
    RGB_GruenNeu = RGB_Gruen5
    RGB_BlauNeu = RGB_Blau5
End Sub

Private Sub Balken_Mitte2_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot6, RGB_Gruen6, RGB_Blau6)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot6
    RGB_GruenNeu = RGB_Gruen6
    RGB_BlauNeu = RGB_Blau6
End Sub

Private Sub Balken_Mitte3_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot7, RGB_Gruen7, RGB_Blau7)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot7
    RGB_GruenNeu = RGB_Gruen7
    RGB_BlauNeu = RGB_Blau7
End Sub

Private Sub Balken_Mitte4_Click()
    Me.Farbe_Neu.BackColor = RGB(RGB_Rot8, RGB_Gruen8, RGB_Blau8)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = RGB_Rot8
    RGB_GruenNeu = RGB_Gruen8
    RGB_BlauNeu = RGB_Blau8
End Sub

Private Sub Balken_Rechts_Click()
    Me.Farbe_Neu.BackColor = RGB(0, 0, 0)
    'Farbe fr Einstellungen merken
    RGB_RotNeu = 0
    RGB_GruenNeu = 0
    RGB_BlauNeu = 0
End Sub

Private Sub Button_OK_Click()
   
    FarbeAendern = True
   
    DoCmd.Close
        
End Sub

Private Sub Farbe_Blau_Click()
    RGB_Rot = 0
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Blau1_Click()
    RGB_Rot = 42
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Blau2_Click()
    RGB_Rot = 85
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Blau3_Click()
    RGB_Rot = 128
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Blau4_Click()
    RGB_Rot = 170
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Blau5_Click()
    RGB_Rot = 212
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan1_Click()
    RGB_Rot = 0
    RGB_Gruen = 212
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan2_Click()
    RGB_Rot = 0
    RGB_Gruen = 170
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan3_Click()
    RGB_Rot = 0
    RGB_Gruen = 128
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan4_Click()
    RGB_Rot = 0
    RGB_Gruen = 85
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Cyan5_Click()
    RGB_Rot = 0
    RGB_Gruen = 42
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb_Click()
    RGB_Rot = 255
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb1_Click()
    RGB_Rot = 212
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb2_Click()
    RGB_Rot = 170
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb3_Click()
    RGB_Rot = 128
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb4_Click()
    RGB_Rot = 85
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gelb5_Click()
    RGB_Rot = 42
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Grau_Click()
    RGB_Rot = 128
    RGB_Gruen = 128
    RGB_Blau = 128
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen1_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 42
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen2_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 85
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen3_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 128
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen4_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 170
    Balken_fuellen
End Sub

Private Sub Farbe_Gruen5_Click()
    RGB_Rot = 0
    RGB_Gruen = 255
    RGB_Blau = 212
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 255
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta1_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 212
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta2_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 170
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta3_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 128
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta4_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 85
    Balken_fuellen
End Sub

Private Sub Farbe_Magenta5_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 42
    Balken_fuellen
End Sub

Private Sub Farbe_Rot_Click()
    RGB_Rot = 255
    RGB_Gruen = 0
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Rot1_Click()
    RGB_Rot = 255
    RGB_Gruen = 42
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Rot2_Click()
    RGB_Rot = 255
    RGB_Gruen = 85
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Rot3_Click()
    RGB_Rot = 255
    RGB_Gruen = 128
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Rot4_Click()
    RGB_Rot = 255
    RGB_Gruen = 170
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Farbe_Rot5_Click()
    RGB_Rot = 255
    RGB_Gruen = 212
    RGB_Blau = 0
    Balken_fuellen
End Sub

Private Sub Form_Open(Cancel As Integer)
    'bergebene bisherige Farbe anzeigen
    Me.Farbe_Aktuell.BackColor = RGB(RGB_Rot, RGB_Gruen, RGB_Blau)
    
    'Farbkreis initialisieren
    Me.Farbe_Rot.BackColor = RGB(255, 0, 0)
    Me.Farbe_Rot1.BackColor = RGB(255, 42, 0)
    Me.Farbe_Rot2.BackColor = RGB(255, 85, 0)
    Me.Farbe_Rot3.BackColor = RGB(255, 128, 0)
    Me.Farbe_Rot4.BackColor = RGB(255, 170, 0)
    Me.Farbe_Rot5.BackColor = RGB(255, 212, 0)
    Me.Farbe_Gelb.BackColor = RGB(255, 255, 0)
    Me.Farbe_Gelb1.BackColor = RGB(212, 255, 0)
    Me.Farbe_Gelb2.BackColor = RGB(170, 255, 0)
    Me.Farbe_Gelb3.BackColor = RGB(128, 255, 0)
    Me.Farbe_Gelb4.BackColor = RGB(85, 255, 0)
    Me.Farbe_Gelb5.BackColor = RGB(42, 255, 0)
    Me.Farbe_Gruen.BackColor = RGB(0, 255, 0)
    Me.Farbe_Gruen1.BackColor = RGB(0, 255, 42)
    Me.Farbe_Gruen2.BackColor = RGB(0, 255, 85)
    Me.Farbe_Gruen3.BackColor = RGB(0, 255, 128)
    Me.Farbe_Gruen4.BackColor = RGB(0, 255, 170)
    Me.Farbe_Gruen5.BackColor = RGB(0, 255, 212)
    Me.Farbe_Cyan.BackColor = RGB(0, 255, 255)
    Me.Farbe_Cyan1.BackColor = RGB(0, 212, 255)
    Me.Farbe_Cyan2.BackColor = RGB(0, 170, 255)
    Me.Farbe_Cyan3.BackColor = RGB(0, 128, 255)
    Me.Farbe_Cyan4.BackColor = RGB(0, 85, 255)
    Me.Farbe_Cyan5.BackColor = RGB(0, 42, 255)
    Me.Farbe_Blau.BackColor = RGB(0, 0, 255)
    Me.Farbe_Blau1.BackColor = RGB(42, 0, 255)
    Me.Farbe_Blau2.BackColor = RGB(85, 0, 255)
    Me.Farbe_Blau3.BackColor = RGB(128, 0, 255)
    Me.Farbe_Blau4.BackColor = RGB(170, 0, 255)
    Me.Farbe_Blau5.BackColor = RGB(212, 0, 255)
    Me.Farbe_Magenta.BackColor = RGB(255, 0, 255)
    Me.Farbe_Magenta1.BackColor = RGB(255, 0, 212)
    Me.Farbe_Magenta2.BackColor = RGB(255, 0, 170)
    Me.Farbe_Magenta3.BackColor = RGB(255, 0, 128)
    Me.Farbe_Magenta4.BackColor = RGB(255, 0, 85)
    Me.Farbe_Magenta5.BackColor = RGB(255, 0, 42)
    
    'Mittleren Balken initialisieren
    Farbe_Grau_Click
    
End Sub

Private Sub Formular_schliessen_Click()
On Error GoTo Err_Formular_schliessen_Click


    DoCmd.Close

Exit_Formular_schliessen_Click:
    Exit Sub

Err_Formular_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Formular_schliessen_Click
    
End Sub
